local assets =
{
	Asset("ANIM", "anim/earlkeith.zip"),
    Asset("ATLAS", "images/inventoryimages/earlkeith.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("earlkeith")
    inst.AnimState:SetBuild("earlkeith")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "earlkeith"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/earlkeith.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("earlkeith", fn, assets)